%function [xr] = encode(x,Fs)
% returns the compressed reconstruction, prints the compression ratio and
% plots the signal vs reconstruction

% It splits the audio file into 11.6 ms chunks, with .7 ms of overlap
% between adjacent chunks. In other words, each frame has 10.9 ms of new
% data. Each frame is submitted to the psychoacoustic model and then
% compressed using the polyphase filter bank.

clear all;
close all;
clc;

[x, Fs] = audioread('test.wav');


% keep count of bits used
totalBits = 0;
bits = 16;

% build array of frequencies
FFTLength = 512;
f=(1:FFTLength/2)*(Fs/FFTLength);

% set number of filters
M = 32;

% set filter length;
L = 2*M;

w = zeros(1,L);
h = zeros(M,L);
g = zeros(M,L);


if size(x,2) == 1
    x = transpose(x);   %convert input x into a row vector
end

xr = zeros(1,length(x));

% define the low-pass window
for n = 1:L
   w(1,n) = sin((pi/(2*M))*(n - 1 + 0.5));
end

for k = 1:M	
   %compute analysis and synthesis filters
   for n = 1:L
      h(k,n) = w(n)*sqrt(2/M)*cos(((2*(n - 1) + M + 1) * (2*(k - 1) + 1) * pi)/(4*M));  % analysis filter
   	g(k,L - n + 1) = h(k,n);   % synthesis filter
   end
end

start = 1;

% window the signal into FFTLength frames
while (start <= (length(x) - FFTLength + 1))
   % disp(start);
   % (length(x) - FFTLength + 1)-start 
   % window the input
   
   xF = x(start:start + FFTLength - 1);
   
   if nnz(xF)>0
       %find the masking threshold for the window
       thres = findThreshold(xF);
       %thres = ath(f);

       % send the signal into the filter banks
       [filtered, totalBits] = filterBanks8(xF, h, g, Fs, bits, f, thres, FFTLength, totalBits);
   else
       filtered=xF;
   end
   
   % build up final reconstructed signal
   xr(start:start + FFTLength - 1) = xr(start:start + FFTLength - 1) + filtered;
   
   start = start + FFTLength - FFTLength/16;    % overlap of FFTLength/16 = 32 bits

end

figure;
%plot original and reconstructed signals
subplot(2,1,1),plot(x,'b');
title('original song')
subplot(2,1,2),plot(xr,'r');
title('reconstructed song')

figure;
%plot FFTs of original and reconstructed signals
subplot(2,1,1),plot(abs(fft(x)),'b');
title('FFT of original song')
subplot(2,1,2),plot(abs(fft(xr)),'r');
title('FFT of reconstructed song')

figure;
% plot FFT error
plot(abs(fft(x)) - abs(fft(xr)));
title('FFT error')

% calculate compression ratio
bitsBefore = length(x) * bits;
disp(['Number of bits before compression: ', num2str(bitsBefore)]);
bitsAfter = totalBits;
disp(['Number of bits after compression: ', num2str(bitsAfter)]);
percent = bitsAfter / bitsBefore * 100;
disp(['Compression ratio: ', num2str(percent), '%']);
